function [por_avg,vel_avg,vel_s_check,massloss,...
    por_ax,vel_avg_ax,vel_s_ax,volvelnorm,...
    radporDat,radvelDat,velDatHist,velprof_1dX,velprof_1dY,qCumuDat] = hydrodynamics(par,vel_s,d_v,...
    R_tube,CR_tube,CC_tube,tot_slices,slice_i,slice_f,...
    volmold,volmask,volmag,volvelori,volvel)
%% Bed hydrodynamics

size_im=size(volmold);
sz_vox = (par.FOV)/(par.NO_SAMPLES);    % voxel size (assuming isotropic) in mm

%% MR Images

% Magnitude image
% figure;
% imagesc(squeeze(volmag(round(end/2),:,slice_i:slice_f)))
% title('Magnitude image')
% colormap gray
% axis equal,axis off
% c = colorbar;
% ylabel(c, '{\it I}/{\it I}_{max}','fontsize',16)
% figure;
% imagesc(volmag(:,:,round(end/2)))
% title('Magnitude image')
% colormap gray
% axis equal,axis off
% c = colorbar;
% ylabel(c, '{\it I}/{\it I}_{max}','fontsize',16)

% Porosity image
% figure;
% imagesc(squeeze(volmask(round(end/2),:,slice_i:slice_f)))
% title('Porosity image')
% colormap gray
% axis equal,axis off
% c = colorbar;
% ylabel(c, '{\epsilon}','fontsize',20)
% figure;
% imagesc(volmask(:,:,round(end/2)))
% title('Porosity image')
% colormap gray
% axis equal,axis off
% c = colorbar;
% ylabel(c, '{\epsilon}','fontsize',20)

% Velocity image
figure;
imagesc(squeeze(volvel(round(end/2),:,((tot_slices/4)+1):(tot_slices-(tot_slices/4)))./vel_s))
title('Figure 4 a/e/i: Longitudinal velocity map')
colormap jet
axis equal,axis off
c = colorbar;
ylabel(c, '{\it v}/{\it v}_s','fontsize',16)
figure;
imagesc(volvel(:,:,round(end/2))./vel_s)
title('Figure 4 c/g/k: Transverse velocity map ')
colormap jet
axis equal,axis off
c = colorbar;
ylabel(c, '{\it v}/{\it v}_s','fontsize',16)

%% Axial porosity, average velocity and superficial velocity

por_ax = [];
vel_avg_ax = [];
for i=slice_i:slice_f
    imMold = volmold(:,:,i);
    imMask = volmask(:,:,i);
    imVel = volvel(:,:,i);
    % Porosity calculation:
    vox_cs_count = sum(imMold(:));                  % Number of pixels in cross section [-]
    vox_fl_count = sum(imMask(:));                  % Number of fluid pixels [-]
    por = (vox_fl_count)/(vox_cs_count);            % Axial porosity [-]
    por_ax = [por_ax por];                          % Storage of axial porosity [-] 
    % Average velocity
    idx = find(imMask);                             % Indices of the fluid pixels
    loc_vel = imVel(idx);                           % Array of local velocities [cm/s]
    vel_avg = mean(loc_vel);                        % Average axial velocity [cm/s]
    vel_avg_ax = [vel_avg_ax vel_avg];              % Storage of the axial average velocity [cm/s]
end
vel_s_ax = vel_avg_ax.*por_ax;

% figure;
% plot((slice_i:slice_f),por_ax);
% title('Porosity across tube')
% xlabel('Slice number')
% ylabel('Porosity [-]')
% figure;
% plot((slice_i:slice_f),vel_avg_ax);
% title('Average axial velocity across tube')
% xlabel('Slice number')
% ylabel('Average axial velocity [cm/s]')
% figure;
% plot((slice_i:slice_f),vel_s_ax);
% title('Superficial velocity across tube')
% xlabel('Slice number')
% ylabel('Superficial velocity [cm/s]')

%% Velocity histogram

velDatHistOri = [];
for i=slice_i:slice_f
    imMask = volmask(:,:,i);
    imVelOri = volvelori(:,:,i);
    idx = find(imMask);
    nzdataOri = imVelOri(idx);
    velDatHistOri = [velDatHistOri; nzdataOri./vel_s];
end
velDatHist = [];
for i=slice_i:slice_f
    imMask = volmask(:,:,i);
    imVel = volvel(:,:,i);
    idx = find(imMask);
    nzdata = imVel(idx);
    velDatHist = [velDatHist; nzdata./vel_s];
end
figure;
histogram(velDatHistOri,'Normalization','PDF')     % Normalized histogram (bin count divided by total population count)
title('Figure 3-a,c,e: Probability density function')
ylabel('Probability density')
xlabel('Normalized axial velocity')
figure;
histogram(velDatHist,'Normalization','PDF')     % Normalized histogram (bin count divided by total population count)
title('Figure 3-b,d,f: Probability density function')
ylabel('Probability density')
xlabel('Normalized axial velocity')

% Mass balance check I:
por_avg = mean(por_ax);                                                    % Average or overall porosity [-] (way 1)
numfluid = sum(volmask(:,:,slice_i:slice_f),'all');                        % Number of fluid pixels in roi [-]
numtot = sum(volmold(:,:,slice_i:slice_f),'all');                          % Total number of pixels in roi [-]
por_avg = numfluid/numtot;                                                 % Average or overall porosity [-] (way 2)
vel_avg = mean(velDatHist.*vel_s);                                         % Average velocity [cm/s]                     
vel_s_ax = vel_avg_ax.*por_ax;                                             % Axial superficial velocity [cm/s]
vel_s_check = por_avg.*vel_avg;                                            % Superficial velocity [cm/s] (way 1)
vel_s_check = mean(vel_s_ax);                                              % Superficial velocity [cm/s] (way 2)

%% Data selection shells

radii = R_tube:-1:1;
% Generate disks:
disks = zeros(size_im(1),size_im(2),length(radii));
for i=1:length(radii)
    radius=i;
    center = [CR_tube, CC_tube];
    points_2D = [repmat(([1:size(volmask,1)]-center(1))',size(volmask,2),1), repelem(([1:size(volmask,2)]-center(2))',size(volmask,1),1)];
    imDisk = (sum(points_2D.* points_2D,2)< radius*radius);
    imDisk = reshape(imDisk, size(volmask,[1,2]));
    disks(:,:,i) = imDisk;
end

% Generate annuli:
walldist = zeros(1,length(radii));
annuli = zeros(size_im(1),size_im(2),length(radii));
for i=1:length(radii)
    if i<length(radii)
        rip = radii(i);
        rim = radii(i+1);
        ri = (rip+rim)/2;
        imAnnulus = disks(:,:,rip)-disks(:,:,rim);
    else
        rip = radii(i);
        rim = 0;
        ri = (rip+rim)/2;
        imAnnulus = disks(:,:,rip);
    end
    walldist(i) = R_tube-ri;
    annuli(:,:,i) = imAnnulus;
end 

%% Radial porosity and velocity profile

por_azi_avg = zeros(1,length(radii));
vel_azi_avg = zeros(1,length(radii));
for i=1:length(radii)
    
    l = slice_f-slice_i+1;
    ring = repmat(annuli(:,:,i),[1 1 l]);
    numVox = sum(ring(:));
    
    imMask = volmask(:,:,slice_i:slice_f);
    imVel = volvel(:,:,slice_i:slice_f);
    
    imMask = imMask.*ring;
    idx = find(imMask);
    
    loc_vel = imVel(idx);
    porBin = length(loc_vel)/numVox;
    velBin = sum(loc_vel(:))/numVox;
    
    por_azi_avg(i) = porBin;
    vel_azi_avg(i) = velBin; 
end
radporDat = [(((walldist-0).*sz_vox)./d_v); por_azi_avg]';
radvelDat = [(((walldist-0).*sz_vox)./d_v); (vel_azi_avg./vel_s)]';
velintDat = [radvelDat(:,1) radvelDat(:,2)./radporDat(:,2)];
figure;
plot(radporDat(:,1),radporDat(:,2));
title('Figure 2-a,c,e: Radial porosity profile')
xlabel('Normalized wall distance')
ylabel('Azimuthal-averaged porosity')
figure;
plot(radvelDat(:,1),radvelDat(:,2));
title('Figure 2-a,c,e: Radial velocity profile')
xlabel('Normalized wall distance')
ylabel('Normalized azimuthal-averaged axial velocity')
% figure;
% plot(velintDat(:,1),velintDat(:,2));
% title('Radial velocity profile')
% xlabel('Normalized wall distance')
% ylabel('Normalized azimuthal-averaged interstitial axial velocity')

%% 1-D velocity profiles:

velprof_1dXOri = [(((1:size_im(2))-(round(size_im(2)/2))).*sz_vox);...
     (volvelori(round(end/2),:,round(end/2))./vel_s)];
velprof_1dYOri = [(((1:size_im(2))-(round(size_im(2)/2))).*sz_vox);...
     (volvelori(:,round(end/2),round(end/2))./vel_s)'];
velprof_1dX = [(((1:size_im(2))-(round(size_im(2)/2))).*sz_vox);...
     (volvel(round(end/2),:,round(end/2))./vel_s)];
velprof_1dY = [(((1:size_im(2))-(round(size_im(2)/2))).*sz_vox);...
     (volvel(:,round(end/2),round(end/2))./vel_s)'];

figure;
plot(velprof_1dXOri(1,:),velprof_1dXOri(2,:));
title('Figure 5-a,c,e: 1-D velocity profile along the x-axis')
xlim([-(R_tube*sz_vox) (R_tube*sz_vox)])
xlabel('Distance from the wall center {\it r}')
ylabel('{\it v}/{\it v}_s','fontsize',16)
figure;
plot(velprof_1dX(1,:),velprof_1dX(2,:));
title('Figure 5-b,d,f: 1-D velocity profile along the x-axis')
xlim([-(R_tube*sz_vox) (R_tube*sz_vox)])
xlabel('Distance from the wall center {\it r}')
ylabel('{\it v}/{\it v}_s','fontsize',16)

% figure;
% plot(velprof_1dYOri(1,:),velprof_1dYOri(2,:));
% title('Figure 5-a,c,e: 1-D velocity profile along the x-axis')
% xlim([-(R_tube*sz_vox) (R_tube*sz_vox)])
% xlabel('Distance from the wall center {\it r}')
% ylabel('{\it v}/{\it v}_s','fontsize',16)
% figure;
% plot(velprof_1dY(1,:),velprof_1dY(2,:));
% xlim([-(R_tube*sz_vox) (R_tube*sz_vox)])
% title('1-D velocity profile along the y-axis')
% xlabel('Distance from the wall center {\it r}')
% ylabel('{\it v}/{\it v}_s','fontsize',16)

%% Cumulative flow rate profile:

vel_azi_avg = zeros(1,length(radii));
qBin = zeros(1,length(radii));

for i=1:length(radii)

    l = slice_f-slice_i+1;
    ring = repmat(annuli(:,:,i),[1 1 l]);
    imVel = volvel(:,:,slice_i:slice_f);
    idx = find(ring);
    loc_vel = imVel(idx);
    vel_azi_avg(i) = mean(loc_vel);

    imMold = volmold(:,:,i);
    vox_cs_count = sum(imMold(:));      % Number of pixels in cross section [-]
    csring = annuli(:,:,i);
    vox_csr_count = sum(csring(:));     % Number of pixels in cross section of ring [-]
    q_s = vel_s.*vox_cs_count;
    q_azi = vel_azi_avg(i).*vox_csr_count;
    qBin(i) = q_azi./q_s;

end

qCumu = sum(qBin(:));
massloss = (1-qCumu)*100;    % percentage mass loss

qBinNew = zeros(1,length(radii)+1);
for i=length(radii):-1:1
    qBinNew(i+1) = sum(qBin(1:i));
end
qCumuDat = [0 (((0.5+walldist).*sz_vox)./d_v); qBinNew(end)-qBinNew]';

figure;
plot(qCumuDat(:,1),qCumuDat(:,2));
title('Figure 2-b,d,f: Cumulative flow rate profile')
xlabel('Normalized wall distance')
ylabel('Normalized cumulative flow rate')

%% Save data

% save 'MrImages/workspace.mat'
% 
% filename = 'MrImages/radpordat.mat';
% save( filename, 'radporDat' );
% filename = 'MrImages/radveldat.mat';
% save( filename, 'radvelDat' );
% filename = 'MrImages/velhistdat.mat';
% save( filename, 'velDatHist' );
% filename = 'MrImages/velprof1dXdat.mat';
% save( filename, 'velprof_1dX' );
% filename = 'MrImages/velprof1dYdat.mat';
% save( filename, 'velprof_1dY' );
% filename = 'MrImages/cumuqdat.mat';
% save( filename, 'qCumuDat' );

volvelnorm = zeros(size(volvel));
for i=1:tot_slices
    
    imMold = volmold(:,:,i);
    imMask = volmask(:,:,i);
    imMag = volmag(:,:,i);
    imVel = volvel(:,:,i)./vel_s;
    volvelnorm(:,:,i) = imVel;
    
%     filename = 'MrImages/MoldImageSlice' + string(i) + '.mat';
%     save( filename, 'imMold' );
%     filename = 'MrImages/MaskImageSlice' + string(i) + '.mat';
%     save( filename, 'imMask' );
%     filename = 'MrImages/MagnitudeImageSlice' + string(i) + '.mat';
%     save( filename, 'imMag' );
%     filename = 'MrImages/VelocityImageSlice' + string(i) + '.mat';
%     save( filename, 'imVel' );

end

end